/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.util;

import java.io.File;
import java.net.URL;
import org.apusic.jocky.JockyPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class Utils {
    public static void showErrorDialog(Throwable e) {
        Utils.showErrorDialog(e == null ? "Error" : e.getMessage());
    }

    public static void showErrorDialog(String displayMessage) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Utils.showErrorDialog(shell, displayMessage);
    }

    public static void showErrorDialog(final Shell shell, String message) {
        final String notNullMessage = message == null ? "Error" : message;
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)notNullMessage);
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    public static String getJockyLocation() {
        try {
            Bundle bundle = JockyPlugin.getDefault().getBundle();
            URL jockyJar = bundle.getEntry("jocky.jar");
            String location = new File(Platform.asLocalURL((URL)jockyJar).getFile()).getAbsolutePath();
            return location;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

