/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.property;

import org.apusic.jocky.JockyPlugin;
import org.apusic.jocky.JockySettings;
import org.apusic.jocky.internal.JockyBuildFileCreator;
import org.apusic.jocky.preference.IJockyPreference;
import org.apusic.jocky.util.Utils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class JockyProjectPropertyPage
extends PropertyPage {
    private Button chkJockyEnable = null;
    private Text txtBuildFile = null;
    private Text txtCompileRootDir = null;
    private Button btnJockyOutputBrowser;
    private Combo cmbScrambleLevel = null;
    private Combo cmbTarget = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        GridData data = null;
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        this.chkJockyEnable = new Button(composite, 32);
        this.chkJockyEnable.setText("Enable Jocky");
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.chkJockyEnable.setLayoutData((Object)data);
        this.chkJockyEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JockyProjectPropertyPage.this.enableJocky();
            }
        });
        Label lab = new Label(composite, 0);
        data = new GridData();
        data.horizontalIndent = 20;
        lab.setLayoutData((Object)data);
        lab.setText("Jocky build file:");
        this.txtBuildFile = new Text(composite, 2048);
        data = new GridData(768);
        this.txtBuildFile.setLayoutData((Object)data);
        this.txtBuildFile.setText("jocky_build.xml");
        this.txtBuildFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JockyProjectPropertyPage.this.txtBuildXmlModified();
            }
        });
        new Label(composite, 0);
        lab = new Label(composite, 0);
        lab.setText("Scramble level:");
        data = new GridData();
        data.horizontalIndent = 20;
        lab.setLayoutData((Object)data);
        this.cmbScrambleLevel = new Combo(composite, 2056);
        this.cmbScrambleLevel.setItems(JockySettings.getScrambleLevels());
        data = new GridData(768);
        this.cmbScrambleLevel.setLayoutData((Object)data);
        this.cmbScrambleLevel.setText(JockySettings.getDefaultLevel());
        new Label(composite, 0);
        lab = new Label(composite, 0);
        lab.setText("Target VM:");
        data = new GridData();
        data.horizontalIndent = 20;
        lab.setLayoutData((Object)data);
        this.cmbTarget = new Combo(composite, 2056);
        this.cmbTarget.setItems(JockySettings.getTargets());
        data = new GridData(768);
        this.cmbTarget.setLayoutData((Object)data);
        this.cmbTarget.setText(JockySettings.getDefaultTarget());
        new Label(composite, 0);
        lab = new Label(composite, 0);
        lab.setText("Output directory:");
        data = new GridData();
        data.horizontalIndent = 20;
        lab.setLayoutData((Object)data);
        this.txtCompileRootDir = new Text(composite, 2048);
        data = new GridData(768);
        this.txtCompileRootDir.setLayoutData((Object)data);
        this.txtCompileRootDir.setText("jocky");
        this.txtCompileRootDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JockyProjectPropertyPage.this.txtOutputDirModified();
            }
        });
        this.btnJockyOutputBrowser = new Button(composite, 8);
        this.btnJockyOutputBrowser.setText("&Browser");
        this.btnJockyOutputBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JockyProjectPropertyPage.this.jockyOutputBrowse();
            }
        });
        this.initialDefaultValues();
        this.enableJocky();
        this.noDefaultAndApplyButton();
        return composite;
    }

    private void initialDefaultValues() {
        IJockyPreference preference = JockyPlugin.getDefault().getJockyPreferenceStore().getPreference(this.getJavaProject());
        if (preference != null) {
            String target;
            String scrambleLevel;
            String compileRootDir;
            String buildFile = preference.getBuildFile();
            if (buildFile != null && buildFile.trim().length() > 0) {
                this.txtBuildFile.setText(buildFile);
            }
            if ((compileRootDir = preference.getCompileRootDir()) != null && compileRootDir.trim().length() > 0) {
                this.txtCompileRootDir.setText(compileRootDir);
            }
            if ((scrambleLevel = preference.getScrambleLevel()) != null && scrambleLevel.trim().length() > 0) {
                this.cmbScrambleLevel.setText(scrambleLevel);
            }
            if ((target = preference.getTarget()) != null && target.trim().length() > 0) {
                this.cmbTarget.setText(target);
            }
            this.chkJockyEnable.setSelection(preference.isJockyEnable());
        } else {
            this.setErrorMessage("This project is not a valid java project.");
        }
    }

    private void jockyOutputBrowse() {
        String dir;
        DirectoryDialog dlg = new DirectoryDialog(this.getShell(), 4);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource resource = (IResource)javaProject.getAdapter((Class)clazz);
            dlg.setFilterPath(resource.getLocation().toOSString());
        }
        if ((dir = dlg.open()) != null && dir.trim().length() > 0) {
            this.txtCompileRootDir.setText(dir);
        }
    }

    private void enableJocky() {
        boolean jockyEnable = this.chkJockyEnable.getSelection();
        this.txtBuildFile.setEnabled(jockyEnable);
        this.txtCompileRootDir.setEnabled(jockyEnable);
        this.btnJockyOutputBrowser.setEnabled(jockyEnable);
        this.cmbScrambleLevel.setEnabled(jockyEnable);
        this.cmbTarget.setEnabled(jockyEnable);
    }

    private void txtBuildXmlModified() {
        String buildFile = this.txtBuildFile.getText().trim();
        if (buildFile.length() == 0) {
            this.setErrorMessage("Jocky ant build file can not be null");
        } else if (!buildFile.toLowerCase().endsWith(".xml")) {
            this.setErrorMessage("Jocky ant build file is invalid");
        } else {
            this.setErrorMessage(null);
        }
        this.getContainer().updateButtons();
    }

    private void txtOutputDirModified() {
        String outputDir = this.txtCompileRootDir.getText().trim();
        if (outputDir.length() == 0) {
            this.setErrorMessage("You must specify the jocky output directory");
        } else {
            this.setErrorMessage(null);
        }
        this.getContainer().updateButtons();
    }

    private IJavaProject getJavaProject() {
        IAdaptable obj = this.getElement();
        if (obj instanceof IJavaProject) {
            return (IJavaProject)obj;
        }
        if (obj instanceof IProject) {
            return JavaCore.create((IProject)((IProject)obj));
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IJavaProject)obj.getAdapter((Class)clazz);
    }

    public boolean performOk() {
        boolean result;
        this.storeSettings();
        if (!this.chkJockyEnable.getSelection()) {
            return true;
        }
        if (this.getErrorMessage() != null && this.getErrorMessage().trim().length() > 0) {
            Utils.showErrorDialog(this.getShell(), this.getErrorMessage());
            return false;
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        IProject project = javaProject.getProject();
        IFile buildFile = project.getFile(this.txtBuildFile.getText().trim());
        String message = "Do you want to generate the jocky build file '" + buildFile.getName() + "'?";
        if (buildFile.exists()) {
            message = "Jocky build file '" + buildFile.getName() + "' exist already, do you want to overwrite it?";
        }
        if (result = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Question", (String)message)) {
            try {
                JockyBuildFileCreator.create(this.getJavaProject());
            }
            catch (Exception e) {
                e.printStackTrace();
                Utils.showErrorDialog(e);
                return false;
            }
        }
        return true;
    }

    private void storeSettings() {
        IJockyPreference preference = JockyPlugin.getDefault().getJockyPreferenceStore().getPreference(this.getJavaProject());
        if (preference != null) {
            preference.setBuildFile(this.txtBuildFile.getText().trim());
            preference.setCompileRootDir(this.txtCompileRootDir.getText().trim());
            preference.setScrambleLevel(this.cmbScrambleLevel.getText());
            preference.setJockyEnable(this.chkJockyEnable.getSelection());
            preference.setTarget(this.cmbTarget.getText());
            preference.store();
        }
    }
}

