/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.preference.internal;

import org.apusic.jocky.JockySettings;
import org.apusic.jocky.preference.IJockyPreference;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class JockyPreferenceImpl
implements IJockyPreference {
    private IJavaProject javaProject;
    private IPreferenceStore store;
    private boolean jockyEnable;
    private String buildFile;
    private String outputDir;
    private String scrambleLevel;
    private String target;

    public JockyPreferenceImpl(IPreferenceStore store, IJavaProject javaProject) {
        String[] array;
        this.store = store;
        this.javaProject = javaProject;
        String str = store.getString(javaProject.getPath().toString());
        this.resetDefaultValues();
        if (str != null && str.trim().length() > 0 && (array = str.split("\\|")) != null && array.length == 5) {
            this.jockyEnable = Boolean.parseBoolean(array[0]);
            this.buildFile = array[1];
            this.outputDir = array[2];
            this.scrambleLevel = array[3];
            this.target = array[4];
        }
    }

    public void resetDefaultValues() {
        this.jockyEnable = false;
        this.buildFile = "jocky_build.xml";
        this.outputDir = "jocky";
        this.scrambleLevel = JockySettings.getDefaultLevel();
        this.target = JockySettings.getDefaultTarget();
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public boolean isJockyEnable() {
        return this.jockyEnable;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getCompileRootDir() {
        return this.outputDir;
    }

    public String getScrambleLevel() {
        return this.scrambleLevel;
    }

    public String getTarget() {
        return this.target;
    }

    public void setJockyEnable(boolean enable) {
        this.jockyEnable = enable;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setCompileRootDir(String dir) {
        this.outputDir = dir;
    }

    public void setScrambleLevel(String level) {
        this.scrambleLevel = level;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void store() {
        String str = this.jockyEnable + "|" + this.buildFile + "|" + this.outputDir + "|" + this.scrambleLevel + "|" + this.target;
        this.store.setValue(this.javaProject.getPath().toString(), str);
    }
}

