'---------------------------------------------------------------------------------------
' ClientBasic Simulation Macro Template
' Copyright (c) 2000 by Protel International
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub Main
  Dim FilePath$, FileName$, DDBName$, DDBSize&

  FilePath$ = "%s"
  FileName$ = "%s"
  DDBName$  = "%s"
  SetupSim& = %d

  DDBSize&  = FileLen(FilePath$ & DDBName$)

  If DDBSize& = -1 Then 
    Call CreateDesign (FilePath$ & DDBName$)
  Else 
    Call OpenDesign   (FilePath$ & DDBName$)
  End If

  Call RefreshDocument (FilePath$, DDBName$, FileName$)
  If SetupSim&=1 Then
    Call SetupSimulator	
  Else
    Call RunSimulator
  End If
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub RefreshDocument (ByVal Path As String, ByVal DDBName As String, ByVal FileName As String)
  Call OpenDesign     (Path$ & DDBName$)
  Call ImportDocument (Path$ & FileName$)
  Call OpenDocument   (FileName$)
  Call CloseDocument
  Call OpenDesign     (Path$ & DDBName$)
  Call OpenDocument   (FileName$)
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub OpenDesign (ByVal DesignPath As String)
  ResetParameters
  AddStringParameter "FileName", DesignPath
  RunProcess "Client:OpenDocument"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub CreateDesign (ByVal DesignPath As String)
  ResetParameters
  AddStringParameter "DocumentType", "Blank Design"
  AddStringParameter "FileName", DesignPath
  RunProcess "Client:CreateNewDocument"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub OpenDocument (ByVal DocumentName As String)
  ResetParameters
  AddStringParameter "DocumentName", DocumentName
  RunProcess "Binder:OpenObject"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub ImportDocument (ByVal FileName As String)
  ResetParameters
  AddStringParameter "FileName", FileName
  RunProcess "Binder:ImportObject"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub CloseDocument
  ResetParameters
  AddStringParameter "ForceSave", "True"
  RunProcess "Client:CloseDocument"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub RunSimulator
  ResetParameters
  RunProcess "SIM:RunSimulator"
End Sub
'---------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------
Sub SetupSimulator	
  ResetParameters
  RunProcess "SIM:RunDialog_AnalysesSetup"
End Sub
'---------------------------------------------------------------------------------------
