/* AMX Mod script. 
* 
* (c) 2003, OLO 
* This file is provided as is (no warranties). 
* 
* Fun Module is required! 
* 
* Admin command: 
* amx_teleportmenu - displays teleport menu
*/ 

#include <translator>
#include <amxmod> 
#include <amxmisc> 

new g_menuPosition[33] 
new g_menuPlayers[33][32] 
new g_menuPlayersNum[33] 
new g_menuOption[33] = { -1 , ... } 
new g_menuOrgin[33][3] 
new g_logFile[16]
new g_cstrikeRunning

public plugin_init() 
{ 
  load_translations("telemenu")
  register_plugin(_T("Teleport Menu"),"0.9.9","default") 
  register_clcmd("amx_teleportmenu","cmdTelMenu",ADMIN_CFG,_T("- displays teleport menu"))
  register_menucmd(register_menuid("Teleport Menu"),1023,"actionTelMenu") 
  get_logfile(g_logFile,15)

  g_cstrikeRunning = (is_running("cstrike") || is_running("czero"))
} 

public actionTelMenu(id,key) 
{ 
    switch(key){ 
    case 6:{ 
            g_menuOption[id] = 1 - g_menuOption[id] 
            displayTelMenu(id,g_menuPosition[id]) 
        }     
    case 7:{ 
            if (g_menuOption[id] < 0) /* unlocking position for the first time */ 
                g_menuOption[id] = 0 
            get_user_origin(id,g_menuOrgin[id]) 
            displayTelMenu(id,g_menuPosition[id]) 
        } 
    case 8: displayTelMenu(id,++g_menuPosition[id]) 
    case 9:    displayTelMenu(id,--g_menuPosition[id]) 
    default:{ 
            new player = g_menuPlayers[id][g_menuPosition[id] * 6 + key] 
             
            new name2[32] 
            get_user_name(player,name2,31) 
             
            if (!is_user_alive(player)) 
            { 
                client_print(id,print_chat,_T("That action can't be performed on dead client ^"%s^""),name2) 
                displayTelMenu(id,g_menuPosition[id]) 
                return PLUGIN_HANDLED 
            } 
             
            if (g_menuOption[id] > 0) 
            { 
                set_user_origin(player,g_menuOrgin[id]) 
            } 
            else 
            { 
                new origin[3] 
                get_user_origin(id,origin) 
                set_user_origin(player,origin) 
            } 
             
            new authid[32],authid2[32], name[32] 

            get_user_authid(id,authid,31) 
            get_user_authid(player,authid2,31) 
            get_user_name(id,name,31) 
                 
            log_to_file(g_logFile,"Cmd: ^"%s<%d><%s><>^" teleport ^"%s<%d><%s><>^"", 
                name,get_user_userid(id),authid, name2,get_user_userid(player),authid2 ) 
         
            switch(get_cvar_num("amx_show_activity"))    { 
            case 2:    client_print(0,print_chat,_T("ADMIN %s: teleport %s"),name,name2) 
            case 1:    client_print(0,print_chat,_T("ADMIN: teleport %s"),name2) 
            }             
             
            displayTelMenu(id,g_menuPosition[id]) 
        } 
    } 
    return PLUGIN_HANDLED 
} 


displayTelMenu(id,pos){ 

    if (pos < 0) 
        return 
         
    get_players(g_menuPlayers[id],g_menuPlayersNum[id]) 
         
    new menuBody[512] 
    new b = 0 
    new i 
    new name[32] 
    new start = pos * 6 
    new bool:blockMenu = (is_user_alive(id)&&g_menuOption[id]<1) ? true : false 
     
    if (start >= g_menuPlayersNum[id]) 
        start = pos = g_menuPosition[id] = 0 
         
    new len = format(menuBody,511, g_cstrikeRunning ? 
      _T("\yTeleport Menu\R%d/%d^n\w^n",id) :
      _T("Teleport Menu %d/%d^n^n",id) , 
        pos+1,(  g_menuPlayersNum[id] / 6 + ((g_menuPlayersNum[id] % 6) ? 1 : 0 )) ) 
         
    new end = start + 6 
    new keys = (1<<9)|(1<<7) 
     
    if (end > g_menuPlayersNum[id]) 
        end = g_menuPlayersNum[id] 
         
    for(new a = start; a < end; ++a) 
    { 
      i = g_menuPlayers[id][a] 
      get_user_name(i,name,31) 
         
      if ( blockMenu ||  !is_user_alive(i) || (get_user_flags(i)&ADMIN_IMMUNITY) ) 
      { 
        ++b     
        if ( g_cstrikeRunning )
          len += format(menuBody[len],511-len,"\d%d. %s^n\w",b,name)
        else
          len += format(menuBody[len],511-len,"#. %s^n",name)
      } 
      else 
      { 
        keys |= (1<<b) 
        len += format(menuBody[len],511-len,"%d. %s^n",++b,name) 
      } 
    } 
     
    if ( g_menuOption[id] > 0 ) // 1 
    { 
        keys |= (1<<6) 
        len += format(menuBody[len],511-len,_T("^n7. To location: %d %d %d^n",id), 
            g_menuOrgin[id][0],g_menuOrgin[id][1] ,g_menuOrgin[id][2]) 
    } 
    else if ( g_menuOption[id] ) // -1 
    { 
      if ( g_cstrikeRunning )
        len += format(menuBody[len],511-len,_T("^n\d7. Current Location^n\w",id)) 
      else
        len += format(menuBody[len],511-len,_T("^n#. Current Location^n",id))
    } 
    else // 0 
    { 
        keys |= (1<<6) 
        len += format(menuBody[len],511-len,_T("^n7. Current Location^n",id)) 
    } 
     
    len += format(menuBody[len],511-len,_T("8. Save Location^n",id)) 
     
    if (end != g_menuPlayersNum[id]) 
    { 
        format(menuBody[len],511-len,_T("^n9. More...^n0. %s",id),
            pos ? _T("Back",id) :
                  _T("Exit",id) )
        keys |= (1<<8) 
    } 
    else 
        format(menuBody[len],511-len,"^n0. %s",
            pos ? _T("Back",id) :
                  _T("Exit",id) )
     
    show_menu(id,keys,menuBody,-1,"Teleport Menu") 
} 

public cmdTelMenu(id,level,cid) 
{ 
  if (cmd_access(id,level,cid,1)) 
    displayTelMenu(id,g_menuPosition[id] = 0) 
     
  return PLUGIN_HANDLED 
} 

