#include <translator>
#include <amxmod>
#include <amxmisc>

new g_cstrikeRunning

new g_langConsole[257]
new g_langMenu[257]
new g_partial
new g_changed[33]
new g_saving[33]
new g_fileName[65]

public plugin_init()
{
	load_translations("langmngr");
	register_plugin(_T("Language Manager"),"0.9.9","default")
	register_concmd("amx_language","cmdLang",-1,_T("[<lang>|save] - displays/sets/saves language"))
	register_menucmd(register_menuid("Language Configuration"),1023,"actionMenu")
	register_clcmd("amx_langmenu","displayMenu",-1,_T("- displays language menu"))
	g_cstrikeRunning = (is_running("cstrike") || is_running("czero"))
}

public plugin_cfg()
{
	if(!loadServerLanguage())
	{
		server_print("Could not read server language: set to English")
		set_server_language("en")
	}
	else
	{
		new lang[33]
		get_server_language(lang, 32)
		strtoupper(lang)
		server_print(_T("* Server language set to: %s"), lang)
	}
	getLanguages()
}

public saveServerLanguage()
{
	if(file_exists(g_fileName))
		delete_file(g_fileName)

	if(!write_file(g_fileName, "; Generated by Language Manager plugin. Do not modify!^n^n; Server Language"))
		return 0

	new lang[33]

	get_server_language(lang,32)
	write_file(g_fileName, lang)

	return 1
}

public loadServerLanguage()
{
	build_path(g_fileName, 64, "$basedir/config/language.ini")
	if(!file_exists(g_fileName))
		return 0
	new text[33], lang[33], len, pos = 0
	while(read_file(g_fileName, pos++, text, 32, len))
	{
		if(text[0]==';')
			continue
		parse(text, lang, 32)
		if(is_language_known(lang))
		{
			set_server_language(lang)
			return 1
		}
	}

	return 0
}

public client_connect(id)
{
	new l, info[129]
	l = get_server_languagenum()
	set_user_languagenum(id, l)
	set_user_languagenum(id, l, 1)
	get_user_info(id, "_lang", info, 128)
	parseLangLine(id, info)
	g_changed[id] = 0
}

public client_infochanged(id)
{
	if(!g_saving[id])
	{
		new info[129]
		get_user_info(id, "_lang", info, 128)
		parseLangLine(id,info)
	}
	else
		g_saving[id] = 0
}

public client_putinserver(id)
{
	set_task(20.0, "displayHelp", id)
}

public displayHelp(id)
{
	new info[2]
	//if(!get_user_info(id, "_lang", info, 1))
	//{
		client_print(id, print_chat, "----")
		client_print(id, print_chat, _T("AMX Mod is multilingual: you can see messages in your own language."))
		client_print(id, print_chat, _T("Type 'amx_langmenu' or 'amx_language' in your console to set it up."))
	//}
	client_print(id, print_center, _T("* Multilingual AMX Mod *"))
}

public saveLang(id, fromConsole, fromUser)
{
	new lang1[33], lang2[33]

	g_saving[id] = 1
	get_user_language(id, lang1, 32)

	if(id)
	{
		get_user_language(id, lang2, 32)
		if(!equal(lang1, lang2))
			client_cmd(id,"setinfo _lang ^"%s %s^"", lang1, lang2)
		else
			client_cmd(id,"setinfo _lang ^"%s^"", lang1)
		client_print(id, fromConsole ? print_console : print_chat, _T("* Your language configuration has been saved"))
		g_changed[id] = 0
	}
	else
	{
		if(saveServerLanguage())
		{
			if(fromUser)
				client_print(id, print_chat, _T("* Server language configuration has been saved"))
			else
				server_print(_T("* Server language configuration has been saved"))
			g_changed[id] = 0
		}
		else
		{
			if(fromUser)
				client_print(id, print_chat, _T("* Server language configuration could not be saved!"))
			else
				server_print(_T("* Server language configuration could not be saved!"))
		}
	}
}

public cmdLang(id)
{
	new line[129], lang[33]
	new disp = 0

	if(read_argc()>1)
	{
		read_args(line, 128)

		if(equali(line,"save",4))
			saveLang(id, 1, id)
		else if(!parseLangLine(id,line))
			disp = 1
	}
	else
		disp = 1

	if(disp)
	{
		get_user_language(id, lang, 32)
		strtoupper(lang)
		console_print(id, _T("Usage: amx_language [save|<lang>]%s"), lang, id?" [...]":"")
		console_print(id, _T("- Current language: %s"), lang)
		if(get_language_support(lang) < 1.0 && id)
		{
			get_user_language(id, lang, 32, 1)
			strtoupper(lang)
			console_print(id, _T("- Fallback language: %s"), lang)
		}
		console_print(id, "%s %s", _T("- Available languages:"), g_langConsole)
		if(g_partial)
			console_print(id,"*: %s",_T("partially supported"))
	}

	return PLUGIN_HANDLED
}

public parseLangLine(id, line[])
{
	new lang[33], lang2[33]
	new Float:sup
	new curlang
	new i, j
	new loop

	loop = 1
	j = 0
	curlang = -1

	while(loop)
	{
		for(i=0; line[j] && line[j]!=' ' && i<32; i++)
			lang[i] = line[j++]
		lang[i] = 0
		while(line[j]==' ')
			j++
		if(!line[j])
			loop = 0
		strtoupper(lang)
		if(is_language_known(lang))
		{
			curlang++
			get_user_language(id, lang2, 33, curlang)
			if(equali(lang, lang2))
			{
				if(!id || curlang)
					loop = 0
				continue
			}
			set_user_language(id, lang, curlang)
			g_changed[id] = 1
			if(id)
			{
				if(curlang)
					loop = 0
				client_cmd(id,_T("echo ^"* %s set to: %s^""), curlang==1?_T("Language"):_T("Fallback Language"), lang)
			}
			else
			{
				loop = 0
				curlang++
				server_print(_T("Server language set to: %s"), lang)
			}
			sup = get_language_support(lang)
			if(sup<1.0)
			{
				if(id)
					client_cmd(id,_T("echo ^"Warning: partial support (%.2f%%%%)^""), 100.0*sup)
				else
					server_print(_T("Warning: partial support (%.2f%%)"), 100.0*sup)
			}
		}
		else if(lang[0])
		{
			if(id)
				client_cmd(id,_T("echo ^"Unsupported language: %s^""), lang)
			else
				server_print(_T("Unsupported language: %s"), lang)
		}
	}

	return curlang?1:0
}

public actionMenu(id,key)
{
	new lang, langname[33]
	new Float:sup

	switch(key)
	{
	case 0:
		{
			lang = get_user_languagenum(id) + 1
			if (lang == get_languagesnum())
				lang = 0
			set_user_languagenum(id,lang)
			get_language(lang,langname,32)
			strtoupper(langname)
			client_print(id,print_chat,_T("* Language set to: %s"),langname)
			g_changed[id] = 1
			sup = get_languagenum_support(lang)
			if(sup < 1.0)
				client_print(id,print_chat,_T("* Warning: partial support (%.2f%%%%)"),sup*100.0)
			displayMenu(id)
		}
	case 1:
		{
			lang = get_user_languagenum(id,1) + 1
			if(lang == get_user_languagenum(id))
				lang++
			if (lang >= get_languagesnum())
				lang = 0
			set_user_languagenum(id,lang,1)
			get_language(lang,langname,32)
			strtoupper(langname)
			client_print(id,print_chat,_T("* Fallback Language set to: %s"),langname)
			sup = get_languagenum_support(lang)
			if(sup < 1.0)
				client_print(id,print_chat,_T("* Warning: partial support (%.2f%%%%)"),sup*100.0)
			displayMenu(id)
		}
	case 2:
		{
			saveLang(id,0,id)
			displayMenu(id)
		}
	case 3:
		{
			lang = get_server_languagenum() + 1
			if (lang >= get_languagesnum())
				lang = 0
			set_server_languagenum(lang)
			g_changed[0] = 1
			get_language(lang,langname,32)
			strtoupper(langname)
			client_print(id,print_chat,_T("* Server language set to: %s"),langname)
			sup = get_languagenum_support(lang)
			if(sup < 1.0)
				client_print(id,print_chat,_T("* Warning: partial support (%.2f%%%%)"),sup*100.0)
			displayMenu(id)
		}
	case 4:
		{
			saveLang(0,0,id)
			displayMenu(id)
		}
	}

	return PLUGIN_HANDLED;
}

public displayMenu(id)
{
	new lang[33], l
	new str[513]
	new keys = 1<<9
	new Float:sup

	new len = format(str, 512, g_cstrikeRunning ? _T("\yLanguage Configuration^n\w^n",id)
	                                            : _T("Language Configuration^n^n",id) )

	get_user_language(id, lang, 32)
	sup = get_language_support(lang)
	strtoupper(lang)
	len += format(str[len], 512-len, g_cstrikeRunning ? "1. %s\R\y%s%s^n\w" : "1. %s    %s%s^n",
		_T("Your Language",id), ((sup<1.0&&g_cstrikeRunning)?"\r":lang), ((sup<1.0&&g_cstrikeRunning)?lang : (sup<1.0?"*":"")))
	keys |= 1<<0

	if(sup < 1.0)
	{
		l = get_user_languagenum(id,1)
		if(l == get_user_languagenum(id))
			l++
		if(l >= get_languagesnum())
			l = 0
		set_user_languagenum(id,l,1)
		get_language(l, lang, 32)
		strtoupper(lang)
		sup = get_language_support(lang)
		len += format(str[len], 512-len, g_cstrikeRunning ? "2. %s\R\y%s%s^n\w^n" : "2. %s   %s%s^n^n",
			_T("Fallback Language",id),
			((sup<1.0&&g_cstrikeRunning)?"\r":lang),
			((sup<1.0&&g_cstrikeRunning)?lang : (sup<1.0?"*":"")))
		keys |= 1<<1
	}
	else
	{
		len += format(str[len], 512-len, g_cstrikeRunning ? "\d2. %s\R-^n\w" : "#. %s   -^n", _T("Fallback Language",id))
	}

	len += format(str[len], 512-len, g_cstrikeRunning ? "3. %s\R\y%s^n\w^n" : "3. %s    %s^n^n",
		_T("Save Configuration",id),
		g_changed[id] ? "*" : "" )
	keys |= 1<<2

	get_server_language(lang, 32)
	strtoupper(lang)
	sup = get_language_support(lang)

	if (get_user_flags(id) & ADMIN_RCON)
	{
		len += format(str[len], 512-len, g_cstrikeRunning ? "4. %s\R\y%s%s^n\w" : "4. %s    %s%s^n",
			_T("Server Language",id),
			((sup<1.0&&g_cstrikeRunning)?"\r":lang),
			((sup<1.0&&g_cstrikeRunning)?lang : (sup<1.0?"*":"")))
		keys |= 1<<3
		len += format(str[len], 512-len, g_cstrikeRunning ? "5. %s\R\y%s^n\w^n" : "5. %s    %s^n^n",
			_T("Save Server Configuration",id),
			g_changed[0] ? "*" : "" )
		keys |= 1<<4
	}
	else
	{
		len += format(str[len],512-len, g_cstrikeRunning ? "\d4. %s\R%s%s^n\w^n" : "#. %s   %s%s^n^n",
			_T("Server Language",id),
			((sup<1.0&&g_cstrikeRunning)?"\r":lang),
			((sup<1.0&&g_cstrikeRunning)?lang : (sup<1.0?"*":"")))
	}

	len += format(str[len], 512-len, _T("0. Exit", id))

	len += format(str[len], 512-len, g_cstrikeRunning ? "^n^n^n\y%s\w^n^n%s" : "^n^n^n%s^n^n%s",
		_T("Available languages:",id), g_langMenu)

	if(g_partial)
		format(str[len], 512-len, "^n^n%s: %s", g_cstrikeRunning?"\r*\w":"*", _T("partially supported",id))

	show_menu(id,keys,str,-1,"Language Configuration")
	return PLUGIN_HANDLED
}

public getLanguages()
{
	new i, j, lang[33]
	new Float:sup

	g_partial = 0
	j = get_languagesnum()
	g_langConsole[0] = 0
	g_langMenu[0] = 0
	server_print(_T("* Multilingual AMX Mod *"))
	server_print(_T("Available languages:"))
	for(i=0; i<j; i++)
	{
		get_language(i, lang, 32)
		strtoupper(lang)
		sup = get_languagenum_support(i)
		if(sup<1.0)
			g_partial++
		server_print("- %s^t: %6.2f%%", lang, 100.0*sup)
		format(g_langConsole, 256, "%s%s%s ", g_langConsole, lang, sup==1.0?"":"*")
		format(g_langMenu, 256, "%s%s%s ", g_langMenu, lang, sup==1.0?" ":(g_cstrikeRunning?"\r*\w":"*"))
	}
}
