/* Get Score for CSStats.
 *
 * (c) 2003, OLO
 * This file is provided as is (no warranties).
 *
 * Function calculates position in rank.
 *
 * Stats:
 * 0 - kills
 * 1 - deaths
 * 2 - headshots
 * 3 - teamkilling
 * 4 - shots
 * 5 - hits
 * 6 - damage
 *
 * Returning cellmin as value in get_score function
 * makes that rank won't be saved.
 *
 * File location: $moddir/addons/amx/plugins/csstats.amx
 */

#include <translator>
#include <amxmod>

/* This is the important function, it is used by CSStats to calculate
* players' ranks. */
public get_score( stats[8] , body[8] )
{
	return stats[0] - stats[1]  - stats[3] // kills - deaths - tks
}


/* This one is just for the server admin to know that he doesn't need
* to declare this plugin in his plugins.ini file. */
public plugin_init()
{
  register_plugin(_T("CSStats rank calculator"),"0.9.9","default")

  server_print(_T("You've added csstats.amx to your plugins.ini!"))
  server_print(_T("You don't need to: CSStats will load it itself."))
  
  pause("ae")
}
