/* Vexd Utility Module Core
*
* by the AMX Mod Dev Team
*
* This file is provided as is (no warranties).
*/

#if defined _vexdum_included
  #endinput
#endif
#define _vexdum_included

#include <VexdUM_const>

// Set Model (CS) Model would be "vip" for the vip model.
native CS_SetModel(id, const Model[]);

// Clear Model (CS)
native CS_ClearModel(id);

// Set Model (TFC)
native TFC_SetModel(id, const Model[], const Skin[]);

// Clear Model (TFC)
native TFC_ClearModel(id);

// Set Player's View to entity iTargetIndex.
native attach_view(id, ent);

// Set Player's Speak Flags.
native set_speak(id, iSpeakFlags);

// Set map lighting, #OFF to disable.
native set_lights(const Lighting[]);

// Get & Set things in an entities Entvars Struct. See HLSDK or look at examples to determine what different variables do.
native entity_get_int(ent, iVar);
native entity_set_int(ent, iVar, iVal);
native Float:entity_get_float(ent, iVar); 
native entity_set_float(ent, iVar, Float:fVal);
native entity_get_vector(ent, iVar, Float:vVal[3]);
native entity_set_vector(ent, iVar, Float:vVal[3]);
native entity_get_edict(ent, iVar);
native entity_set_edict(ent, iVar, iEnt);
native entity_get_string(ent, iVar, szVal[], iLen); 
native entity_set_string(ent, iVar, szVal[]);
native entity_get_byte(ent, iVar);
native entity_set_byte(ent, iVar, iVal);

// Get things in globalvars Struct. See HLSDK or look at examples to determine what different variables do.
native global_get_int(iVar);
native Float:global_get_float(ent, iVar);
native global_get_vector(iVar, Float:vVal[3]);
native global_get_edict(iVar);
native global_get_string(iVar, szVal[], iLen);

// Get & Set things in a players TraceLine Struct. See HLSDK or look at examples to determine what different variables do.
native traceline_get_int(id, iVar);
native traceline_set_int(id, iVar, iVal, iHook = 1);
native Float:traceline_get_float(id, iVar);
native traceline_set_float(id, iVar, Float:fVal, iHook = 1);
native traceline_get_vector(id, iVar, Float:vVal[3]);
native traceline_set_vector(id, iVar, Float:vVal[3], iHook = 1);
native traceline_get_edict(id, iVar);
native traceline_set_edict(id, iVar, iEnt, iHook = 1);

// Hurts/Kills players in a sphere, like an explosion. *CS ONLY*
native radius_damage(inflictor, dmg, mag, Float:orig[3], rad, bit = DMG_BULLET);

// *CS ONLY*
native take_damage(victim, attacker, Float:orig[3], dmg, bit = DMG_BULLET);

native client_death(victim, attacker, wpnName[]);

// Gives you a velocity in the direction a player is looking, iVelocity is the multiplier.
native VelocityByAim(ent, iVel, Float:vRtn[3]);

// Will return the contents of a point (inside map? in sky? outside map? etc.)
native PointContents(Float:fCheckAt[3]);

// Creates an entity, will return the index of the created entity. ClassName must be valid.
native create_entity(szClassname[]);

// Dispatch a KeyValuePair, used for initalizing entities when a map spawns them.
native DispatchKeyValue(ent, szKey[], szValue[]);

// Runs the GameDLL's DispatchSpawn for an entity, I think it's used with DispatchKeyValue.
native DispatchSpawn(ent);

// Sets the model of an Entity.
native entity_set_model(ent, szModel[]);

// Proper origin setting, keeps updated with Half-Life engine.
native entity_set_origin(ent, Float:Orig[3]);

// Sets the Bounding Box Size of an entity.
native entity_set_size(ent, Float:vecMin[3], Float:vecMax[3]);

// Find an entity in the world, will return -1 if nothing is found
native find_entity(ent, szValue[]);

// Find an entity within a given origin and radius
native find_entity_sphere(ent, Float:Orig[3], Float:Rad[3]);

// Remove an entity from the world
native remove_entity(ent);

// Trace a line from Start(X, Y, Z) to End(X, Y, Z), will return the point hit in vReturn[3]
// Will return an entindex if an entity is hit.
native trace_line(ent, Float:fStart[3], Float:fEnd[3], Float:vRtn[3]);

// Traces a line, and returns the normal to the plane hit in vReturn.
// Returns 0 if theres no normal.
native trace_normal(ent, Float:fStart[3], Float:fEnd[3], Float:vRtn[3]);

// Traces what texture an entity is looking at or standing on. set 0 = Trace Forward, set 1 = Trace Below
native trace_texture(ent, szBuf[], iLen, set = 0);

// Changes a Vector to an Angle vector.
native vector_to_angle(Float:fVector[3], Float:vRtn[3]);

// Converts an angle to a vector.
native angle_to_vector(Float:fAngle[3], Float:vRtn[3]);

// Gets the length of a vector (float[3]).
native Float:vector_length(Float:vDist[3]);

// Gets the distance between 2 vectors (float[3]).
native Float:vector_distance(Float:vOrig1[3], Float:vOrig2[3]);

// Set/Get What Engine Messages Are Blocked.
native set_msg_block(iMessage, iMessageFlags);
native get_msg_block(iMessage);

// Precache any file
native precache_generic(szFile[]);

// Precache event
native precache_event(type, szEvent[]);

// playback a precached event
native playback_event(flags,invoker,eventindex,Float:delay,Float:origin[3],Float:angles[3],Float:fparam1,Float:fparam2,iparam1,iparam2,bparam1,bparam2);

// Gets a integer from index's pvPrivateData at offset.
native get_offset_int(ent, offset, linos = 5);

// Sets a integer value in index's pvPrivateData at offset.
native set_offset_int(ent, offset, value, linos = 5);

// Gets a float from index's pvPrivateData at offset.
native Float:get_offset_float(ent, offset, linos = 5);

// Sets a float value in index's pvPrivateData at offset.
native set_offset_float(ent, offset, Float:value, linos = 5);

// Gets number of ents in a map
native get_num_ents();

// Returns maxentities setting
native get_maxentities();

// Checks if index is an existing ent
native is_entity(index);

// Get whole buffer containing keys and their data
native get_info_keybuffer(id, buffer[], length);

// Fake one entity touching another.
native fake_touch(ent1, ent2);

// Bot Natives
native create_bot(name[]);
native remove_bot(id);
native set_bot_run(id, Float:vAngles[3], Float:fMove, Float:sMove, Float:uMove, Buttons, Impulse, mSec);

// Some Misc natives
native dot_points(Float:vSrc[3], Float:vCheck[3], Float:vDir[3]);
native dot_product(Float:vecA[3], Float:vecB[3]);
native can_see(ent1, ent2);
native in_view_cone(ent, Float:Orig[3]);

// Called once every server frame. May cause lag.
forward server_frame();

// Called when 2 entities touch.
forward entity_touch(entity1, entity2);

// Called on an entity's DispatchThink
forward entity_think(entity);

// Called before the engine calculates player movement, etc.
forward client_prethink(id);

// Called after the engine has calculated player movement
forward client_postthink(id);

// Called when a client types kill in console
forward client_kill(id);

// Called when an Emitting Sound is played Server-Side
forward emitsound(entity, const sample[]);

// Called when an Emitting Ambient Sound is played Server-Side
forward emitambientsound(entity, const sample[]);

// Called when a model spawns
forward set_model(edict, const model[]);

// Called whatever an entity looks at
forward traceline(entity1, entity2, hitzone);