/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class V3AnnAdapter
implements DexAnnotationVisitor {
    protected Annotation ann;

    public static void accept(List<Annotation.Item> items, AnnotationVisitor av) {
        if (av == null) {
            return;
        }
        for (Annotation.Item item : items) {
            Object v = item.value;
            if (v instanceof Annotation) {
                AnnotationVisitor av1;
                Annotation a = (Annotation)v;
                if (a.type != null) {
                    av1 = av.visitAnnotation(item.name, a.type);
                    V3AnnAdapter.accept(a.items, av1);
                    av1.visitEnd();
                    continue;
                }
                av1 = av.visitArray(item.name);
                V3AnnAdapter.accept(a.items, av1);
                av1.visitEnd();
                continue;
            }
            if (v instanceof Field) {
                Field e = (Field)v;
                av.visitEnum(item.name, e.getType(), e.getName());
                continue;
            }
            if (v instanceof Method) {
                av.visit(item.name, v);
                continue;
            }
            av.visit(item.name, v);
        }
    }

    public V3AnnAdapter(Annotation ann) {
        this.ann = ann;
    }

    public void visit(String name, Object value) {
        if (value instanceof DexType) {
            value = Type.getType((String)((DexType)value).desc);
        }
        this.ann.items.add(new Annotation.Item(name, value));
    }

    public DexAnnotationVisitor visitAnnotation(String name, String desc) {
        Annotation ann = new Annotation(desc, true);
        this.ann.items.add(new Annotation.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    public DexAnnotationVisitor visitArray(String name) {
        Annotation ann = new Annotation(null, true);
        this.ann.items.add(new Annotation.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    public void visitEnd() {
    }

    public void visitEnum(String name, String desc, String value) {
        this.ann.items.add(new Annotation.Item(name, new Field(null, value, desc)));
    }
}

