/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import p.rn.name.Renamer;

public class JarRemap
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[jar-name]-remap.jar", argName="out-jar")
    private File output;
    @BaseCmd.Opt(opt="c", longOpt="config", required=true, description="config file for remap, this is REQUIRED", argName="config")
    private File config;

    public static void main(String[] args) {
        new JarRemap().doMain(args);
    }

    public JarRemap() {
        super("d2j-jar-remap [options] <jar>", "rename package/class/method/field name in a jar");
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File jar = new File(this.remainingArgs[0]);
        if (!jar.exists()) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = jar.isDirectory() ? new File(jar.getName() + "-remap.jar") : new File(FilenameUtils.getBaseName((String)jar.getName()) + "-remap.jar");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("remap " + jar + " -> " + this.output);
        new Renamer().from(jar).withConfig(this.config).to(this.output);
    }
}

