/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class BaseCmd {
    private final String cmdLineSyntax;
    protected CommandLine commandLine;
    private final String header;
    private Map<String, Field> map = new HashMap<String, Field>();
    protected final Options options = new Options();
    protected String[] remainingArgs;

    public BaseCmd(String cmdLineSyntax, String header) {
        this.cmdLineSyntax = cmdLineSyntax;
        this.header = header;
    }

    protected Object convert(String value, Class<?> type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(File.class)) {
            return new File(value);
        }
        throw new RuntimeException("can't convert [" + value + "] to type " + type);
    }

    protected abstract void doCommandLine() throws Exception;

    public void doMain(String ... args) {
        this.initOptions();
        PosixParser parser = new PosixParser();
        try {
            this.commandLine = parser.parse(this.options, args);
        }
        catch (ParseException ex) {
            this.usage();
            return;
        }
        this.remainingArgs = this.commandLine.getArgs();
        try {
            for (Option option : this.commandLine.getOptions()) {
                String opt = option.getOpt();
                Field f = this.map.get(opt);
                if (f == null) continue;
                Object value = !option.hasArg() ? Boolean.valueOf(true) : this.convert(this.commandLine.getOptionValue(opt), f.getType());
                f.set(this, value);
            }
            this.doCommandLine();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected String getVersionString() {
        return "dex2jar dex-tool-" + BaseCmd.class.getPackage().getImplementationVersion() + ", Apache-2.0";
    }

    protected void initOptionFromClass(Class<?> clz) {
        Field[] fs;
        if (clz == null) {
            return;
        }
        this.initOptionFromClass(clz.getSuperclass());
        for (Field f : fs = clz.getDeclaredFields()) {
            Opt opt = f.getAnnotation(Opt.class);
            if (opt == null) continue;
            f.setAccessible(true);
            if (!opt.hasArg()) {
                boolean b;
                Class<?> type = f.getType();
                if (!type.equals(Boolean.TYPE)) {
                    throw new RuntimeException("the type of " + f + " must be boolean, as it is declared as no args");
                }
                try {
                    b = (Boolean)f.get(this);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (b) {
                    throw new RuntimeException("the value of " + f + " must be false, as it is declared as no args");
                }
            }
            Option option = new Option(opt.opt(), opt.hasArg(), opt.description());
            option.setRequired(opt.required());
            if (!"".equals(opt.longOpt())) {
                option.setLongOpt(opt.longOpt());
            }
            if (!"".equals(opt.argName())) {
                option.setArgName(opt.argName());
            }
            this.options.addOption(option);
            this.map.put(opt.opt(), f);
        }
    }

    protected void initOptions() {
        this.initOptionFromClass(this.getClass());
    }

    protected void usage() {
        HelpFormatter formatter = new HelpFormatter(){

            public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) {
                String xHeader = BaseCmd.this.header;
                if (xHeader != null && !xHeader.equals("")) {
                    this.printWrapped(pw, width, xHeader);
                }
                super.printHelp(pw, width, cmdLineSyntax, header, options, leftPad, descPad, footer, autoUsage);
            }
        };
        formatter.printHelp(this.cmdLineSyntax, "options:", this.options, "version: " + this.getVersionString());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Opt {
        public String argName() default "";

        public String description();

        public boolean hasArg() default true;

        public boolean required() default false;

        public String longOpt() default "";

        public String opt();
    }
}

