/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import p.rn.name.InitOut;

public class DeObfInitCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[file-name]-deobf-init.txt", argName="out-file")
    private File output;

    public static void main(String[] args) {
        new DeObfInitCmd().doMain(args);
    }

    public DeObfInitCmd() {
        super("d2j-init-deobf [options] <jar>", "generate an init config file for deObfuscate a jar");
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File jar = new File(this.remainingArgs[0]);
        if (!jar.exists()) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = jar.isDirectory() ? new File(jar.getName() + "-deobf-init.txt") : new File(FilenameUtils.getBaseName((String)jar.getName()) + "-deobf-init.txt");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("generate " + jar + " -> " + this.output);
        new InitOut().from(jar).to(this.output);
    }
}

