/*
 * Decompiled with CFR 0.152.
 */
package com.apple.dnssd;

import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDRecordRegistrar;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.DomainListener;
import com.apple.dnssd.QueryListener;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.RegisterRecordListener;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;

public abstract class DNSSD {
    public static final int MORE_COMING = 1;
    public static final int DEFAULT = 4;
    public static final int NO_AUTO_RENAME = 8;
    public static final int SHARED = 16;
    public static final int UNIQUE = 32;
    public static final int BROWSE_DOMAINS = 64;
    public static final int REGISTRATION_DOMAINS = 128;
    public static final int MAX_DOMAIN_NAME = 1009;
    public static final int ALL_INTERFACES = 0;
    public static final int LOCALHOST_ONLY = -1;
    protected static DNSSD fInstance;

    public static DNSSDService browse(int n, int n2, String string, String string2, BrowseListener browseListener) throws DNSSDException {
        return DNSSD.getInstance()._makeBrowser(n, n2, string, string2, browseListener);
    }

    public static DNSSDService browse(String string, BrowseListener browseListener) throws DNSSDException {
        return DNSSD.browse(0, 0, string, "", browseListener);
    }

    public static DNSSDService resolve(int n, int n2, String string, String string2, String string3, ResolveListener resolveListener) throws DNSSDException {
        return DNSSD.getInstance()._resolve(n, n2, string, string2, string3, resolveListener);
    }

    public static DNSSDRegistration register(int n, int n2, String string, String string2, String string3, String string4, int n3, TXTRecord tXTRecord, RegisterListener registerListener) throws DNSSDException {
        return DNSSD.getInstance()._register(n, n2, string, string2, string3, string4, n3, tXTRecord, registerListener);
    }

    public static DNSSDRegistration register(String string, String string2, int n, RegisterListener registerListener) throws DNSSDException {
        return DNSSD.register(0, 0, string, string2, null, null, n, null, registerListener);
    }

    public static DNSSDRecordRegistrar createRecordRegistrar(RegisterRecordListener registerRecordListener) throws DNSSDException {
        return DNSSD.getInstance()._createRecordRegistrar(registerRecordListener);
    }

    public static DNSSDService queryRecord(int n, int n2, String string, int n3, int n4, QueryListener queryListener) throws DNSSDException {
        return DNSSD.getInstance()._queryRecord(n, n2, string, n3, n4, queryListener);
    }

    public static DNSSDService enumerateDomains(int n, int n2, DomainListener domainListener) throws DNSSDException {
        return DNSSD.getInstance()._enumerateDomains(n, n2, domainListener);
    }

    public static String constructFullName(String string, String string2, String string3) throws DNSSDException {
        return DNSSD.getInstance()._constructFullName(string, string2, string3);
    }

    public static void reconfirmRecord(int n, int n2, String string, int n3, int n4, byte[] byArray) {
        DNSSD.getInstance()._reconfirmRecord(n, n2, string, n3, n4, byArray);
    }

    public static String getNameForIfIndex(int n) {
        return DNSSD.getInstance()._getNameForIfIndex(n);
    }

    public static int getIfIndexForName(String string) {
        return DNSSD.getInstance()._getIfIndexForName(string);
    }

    protected DNSSD() {
    }

    protected static final DNSSD getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getDNSSDInstance"));
        }
        return fInstance;
    }

    protected abstract DNSSDService _makeBrowser(int var1, int var2, String var3, String var4, BrowseListener var5) throws DNSSDException;

    protected abstract DNSSDService _resolve(int var1, int var2, String var3, String var4, String var5, ResolveListener var6) throws DNSSDException;

    protected abstract DNSSDRegistration _register(int var1, int var2, String var3, String var4, String var5, String var6, int var7, TXTRecord var8, RegisterListener var9) throws DNSSDException;

    protected abstract DNSSDRecordRegistrar _createRecordRegistrar(RegisterRecordListener var1) throws DNSSDException;

    protected abstract DNSSDService _queryRecord(int var1, int var2, String var3, int var4, int var5, QueryListener var6) throws DNSSDException;

    protected abstract DNSSDService _enumerateDomains(int var1, int var2, DomainListener var3) throws DNSSDException;

    protected abstract String _constructFullName(String var1, String var2, String var3) throws DNSSDException;

    protected abstract void _reconfirmRecord(int var1, int var2, String var3, int var4, int var5, byte[] var6);

    protected abstract String _getNameForIfIndex(int var1);

    protected abstract int _getIfIndexForName(String var1);

    static {
        try {
            String string = System.getProperty("com.apple.dnssd.DNSSD");
            if (string == null) {
                string = "com.apple.dnssd.AppleDNSSD";
            }
            fInstance = (DNSSD)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new InternalError("cannot instantiate DNSSD" + exception);
        }
    }
}

