/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.stmt;

import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.NopStmt;
import com.googlecode.dex2jar.ir.stmt.ReturnVoidStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.UnopStmt;
import org.objectweb.asm.Label;

public final class Stmts {
    public static AssignStmt nAssign(Value left, Value right) {
        return new AssignStmt(Stmt.ST.ASSIGN, Exprs.box(left), Exprs.box(right));
    }

    public static AssignStmt nAssign(ValueBox left, ValueBox right) {
        return new AssignStmt(Stmt.ST.ASSIGN, left, right);
    }

    public static JumpStmt nGoto(LabelStmt target) {
        return new JumpStmt(Stmt.ST.GOTO, target);
    }

    public static AssignStmt nIdentity(Value local, Value identityRef) {
        return new AssignStmt(Stmt.ST.IDENTITY, Exprs.box(local), Exprs.box(identityRef));
    }

    public static JumpStmt nIf(Value a, LabelStmt target) {
        return new JumpStmt(Stmt.ST.IF, Exprs.box(a), target);
    }

    public static LabelStmt nLabel() {
        return new LabelStmt(new Label());
    }

    public static LabelStmt nLabel(Label label) {
        return new LabelStmt(label);
    }

    public static UnopStmt nLock(Value op) {
        return new UnopStmt(Stmt.ST.LOCK, Exprs.box(op));
    }

    public static LookupSwitchStmt nLookupSwitch(Value key, int[] lookupValues, LabelStmt[] targets, LabelStmt target) {
        return new LookupSwitchStmt(Exprs.box(key), lookupValues, targets, target);
    }

    public static NopStmt nNop() {
        return new NopStmt();
    }

    public static UnopStmt nReturn(Value op) {
        return new UnopStmt(Stmt.ST.RETURN, Exprs.box(op));
    }

    public static ReturnVoidStmt nReturnVoid() {
        return new ReturnVoidStmt();
    }

    public static TableSwitchStmt nTableSwitch(Value key, int lowIndex, int highIndex, LabelStmt[] targets, LabelStmt target) {
        return new TableSwitchStmt(key, lowIndex, highIndex, targets, target);
    }

    public static UnopStmt nThrow(Value op) {
        return new UnopStmt(Stmt.ST.THROW, Exprs.box(op));
    }

    public static UnopStmt nUnLock(Value op) {
        return new UnopStmt(Stmt.ST.UNLOCK, Exprs.box(op));
    }

    private Stmts() {
    }
}

